\version "2.24.0"
\language "deutsch"

\paper {
  markup-system-spacing = #'((basic-distance . 20))
  system-system-spacing = #'((basic-distance . 20))
  left-margin = 1.8\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 7\mm
  %ragged-last-bottom=##f
  system-count = #4
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Ușa milostivirii"
  subtitle = "Paraclisul Născătoarei de Dumnezeu"
  %composer = "21-25.02.19"
  %meter = "Andante"
  tagline=""
}

global = {
  %#(set-global-staff-size 19)
  \key f \major
  \time 4/4
  \partial 4
  \set Staff.midiInstrument = "clarinet"
  \autoBeamOff
}

womenWords = \lyricmode {
  U -- şa mi -- los -- ti -- vi -- rii des -- chi -- de-o no -- uă,
  bi -- ne -- cu -- vân -- ta -- tă Năs -- că -- toa -- re de Dum -- ne -- zeu,
  ca să nu pie -- rim cei ce nă -- dăj -- du -- im în -- tru ti -- ne,
  ci să ne iz -- bă -- vim prin ti -- ne din ne -- voi, 
  că tu eşti mân -- tu -- i -- rea, mân -- tu -- i -- rea
  nea -- mu -- lui creş -- ti -- nesc.
}

tenorWords = \lyricmode {
  
}

bassWords = \lyricmode {
  \skip 1 \skip 1 \skip 1 \skip 1  \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 
}

sopMusic = \relative c' {
  f4 f f e f g( a) g a b b a( g) a2
  a4 a g a b g a b c( d8[ c]) b4 a g f g2
  f4 f b b a f g g f g a( b) c c d( es) c2
  d2 c4 b a g a f g g f e f2 b4\rest
  f4 f f e f g( a) g2 a4 b c( d8[ c] b4 a) g2
  a2 g4 g f e f2  
  \bar "|."
}

altMusic = \relative c' {
  f4 f f e f e( f) e f g g f( e) f2
  f4 f e f f e f g a2 g4 a g f g2
  f4 f f f f f e e d e f( g) a4 a a2 a 
  a2 a4 g a g f f e e d e f2 b4\rest
  f4 f f e f e( f) e2 f4 g a2( a) g2
  f2 g4 g f e f2
}

bassMusic = \relative c {
  f4 f f e d c2 c4 f b, b c2 c 
  c4 c c c c c c c f2 f4 f e f g2 
  f4 f f f f f c c c c c2 f4 f f2 f
  f2 f4 f f f f f c c d e f2 d4\rest
  f4 f f e d c2 c f4 f f2( f) g2
  f2 e4 e d c f2
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \altMusic }
    >>
    
    \new Staff = "staff" <<
      \clef bass
      \new Voice { \global \bassMusic }
      %\new Voice { \global \voiceOne \tenorMusic }
      %\new Voice { \global \voiceTwo \bassMusic }
      %\new Lyrics \with { alignAboveContext = "staff" } { \menWords }
      %\addlyrics { \menWords }
      \addlyrics { \womenWords }
      %\new Voice { \global \voiceTwo \bassMusic }
      %\new Voice { \global \bassMusic }
      %\addlyrics { \bassWords }
    >>
   >>
>>


midiOutput = \midi {
    \tempo 4 = 60
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \layout { }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}